CREATE OR REPLACE FUNCTION TWawi.view__types__normalize__drop() RETURNS VOID
  AS  $$
  BEGIN

        -- Vom Typ "TWawi.view__pos__type" abhängige Funktionen löschen.
        DROP FUNCTION IF EXISTS TWawi.view__pos__normalize( TWawi.rechnungv_pos );
        DROP FUNCTION IF EXISTS TWawi.view__pos__normalize( TWawi.rechnunge_pos );
        DROP FUNCTION IF EXISTS TWawi.extend_layout__pos( TWawi.view__pos__type );

        -- Vom Typ "TWawi.view__beleg__type" abhängige Funktionen löschen.
        DROP FUNCTION IF EXISTS TWawi.view__beleg__normalize( TWawi.rechnungv_belegext );
        DROP FUNCTION IF EXISTS TWawi.view__beleg__normalize( TWawi.rechnunge_belegext );
        DROP FUNCTION IF EXISTS TWawi.extend_layout__pos__beleg( TWawi.view__beleg__type );
        DROP FUNCTION IF EXISTS TWawi.extend_layout__beleg( TWawi.view__beleg__type );

        -- Typen selbst löschen, falls vorhanden.
        DROP TYPE IF EXISTS TWawi.view__pos__type;
        DROP TYPE IF EXISTS TWawi.view__beleg__type;

  END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION TWawi.view__types__normalize__create() RETURNS VOID
  AS  $$
  BEGIN

        -- Typen löschen, falls vorhanden.
        PERFORM TWawi.view__types__normalize__drop();

        -- FUNCTION TWawi.view__pos__normalize

        -- FUNCTION TWawi.view__beleg__normalize

        -- Typen (wieder) anlegen.
        CREATE TYPE TWawi.view__beleg__type AS (
            dbrid                   varchar(64),
            d_id                    varchar(64),
            d_code                  varchar(5),
            d_wert_tot_netto        numeric(12,2),
            d_wert_tot_brutto       numeric(12,2),
            d_wert_tot_netto_gwaer  numeric(12,2),
            d_wert_tot_brutto_gwaer numeric(12,2),
            d_datum_erfasst         date,
            d_zahlung_tage          integer,
            d_zahlung_done          boolean
            );


        CREATE TYPE twawi.view__pos__type AS (
            dbrid                 varchar(64),
            p_id                  varchar(64),
            p_d_id                varchar(64),
            p_pos                 integer,
            p_preis_sumsubpos     boolean
            );


        -- default columns type

        /*

        CREATE TYPE TWawi.default_columns__wawi_pos__basics__type AS ( --TSystem_Wawi.beleg_p__art
            dbrid                   varchar(64),
            p_id                    varchar(64),
            p_d_id                  varchar(64),
            p_code                  varchar(5),
            p_dokunr                varchar(30),
            p_pos                   integer,

            p_adk_ad_krz            varchar(21),
            p_adk_ad_krz__name      varchar(100),

            p_aknr                  varchar(40),
            p_aknr_idx              varchar(30),
            p_aknr_referenz         varchar(50),
            p_ak_bez                varchar(100),
            );


        CREATE TYPE TWawi.default_columns__wawi_pos__mengen__type AS ( -- TSystem_Wawi.beleg_p__art_menge

            p_menge                 numeric(12,4),
            p_mengel_uf             numeric(12,4),
            p_mengef_uf             numeric(12,4),
            p_mengef_uf             numeric(12,4),

            p_me                    integer,
            p_me_iso                varchar(30),

            p_IsBedarf              boolean
            );


        CREATE TYPE TWawi.default_columns__wawi_pos__mengen_gme__type AS ( -- TSystem_Wawi.beleg_p__art_menge

            p_menge_gme             numeric(12,4),
            p_mengel_gme            numeric(12,4),
            p_mengef_gme            numeric(12,4),
            p_mengef_gme            numeric(12,4),

            p_me_gme_iso            varchar(30),
            );


        CREATE TYPE TWawi.default_columns__wawi_pos__preise__type AS ( -- TSystem_Wawi.beleg_p__art_menge

            p_preis                 numeric(12,4),
            p_mengel_gme            numeric(12,4),
            p_mengef_gme            numeric(12,4),
            p_mengef_gme            numeric(12,4),

            p_preis_sumsubpos       boolean
            );

        */

  END $$ LANGUAGE plpgsql;


SELECT TWawi.view__types__normalize__drop();
SELECT TWawi.view__types__normalize__create();